#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
struct node {
  int time;
  int duration;
  int type;
  node *next;
};
struct queue {
   node *front;
   node *rear;
   int num;
};
queue q[4];
node auxinfo, *evlist;
void  insert(queue *, node *);
void  qremove(queue *, node*);
void  place(node **evlist, node *);
void  popsub(node **evlist, node *auxinfo);
void  arrive(int atime, int dur);
void  depart(int atime, int dur);
int   atime, dtime, dur, qindex;
float count, tottime;
int main()
{
   evlist = NULL;
   count = tottime = 0;
   for(qindex = 0; qindex < 4; qindex++)
   {
     q[qindex].num = 0;
     q[qindex].front = NULL;
     q[qindex].rear = NULL;
   }//end of for
   clrscr();
   printf("Enter time and duration:");
   scanf("%d%d", &auxinfo.time, &auxinfo.duration);
   auxinfo.type = -1; /* an arrival*/
   auxinfo.next = NULL;
   place(&evlist, &auxinfo);
   /* run the simulation as long as */
   /* the event list is not empty   */
   while(evlist != NULL)
   {
      popsub(&evlist, &auxinfo);
      /* check if the next event     */
      /* is an arriveal or departure */
      if(auxinfo.type == -1)
      {
	 atime = auxinfo.time;
	 dur = auxinfo.duration;
	 arrive(atime, dur);
      }
      else
      {
	 /* a departure   */
	 qindex = auxinfo.type;
	 dtime = auxinfo.time;
	 depart(qindex, dtime);
     }
   }
   printf("Average time is %4.2f", tottime/count);
   getch();
   return 0;
}
//*****************
void arrive(int atime, int dur)
{
  int i, j, small;
  // find the shortest queue
  j = 0;
  small = q[0].num;
  for(i = 1; i < 4; i ++)
     if(q[i].num < small)
     {
	small = q[i].num;
	j = i;
     }//end of if and for
  //queue j is the shorthest
  //Insert a new customer node.
  auxinfo.time = atime;
  auxinfo.duration = dur;
  auxinfo.type = j;
  auxinfo.next = NULL;
  insert(&q[j], &auxinfo);
 //check if this is the only node on the queue.
  //if it is, the customer's departure node must
  // be placed on the event list
  if(q[j].num == 1)
  {
     auxinfo.time = atime + dur;
     place(&evlist, &auxinfo);
  }
  //if any input remains, read the next data pair
  // and place an arrival on the event list.
  printf("Enter time:");
  if(scanf("%d", &auxinfo.time) != EOF)
  {
     printf("Enter duration:");
     scanf("%d", &auxinfo.duration);
     auxinfo.type = -1;
     auxinfo.next = NULL;
     place(&evlist, &auxinfo);
  }//enf if
}
//*****************
void depart(int qindex, int dtime)
{
  node *p;
  qremove(&q[qindex], &auxinfo);
  tottime = tottime +(dtime - auxinfo.time);
  count ++;
  //if there are any more customers on the queue
  //place the departure of the next customer onto
  //the event list after computing its departure time
  if(q[qindex].num > 0)
  {
    p = q[qindex].front;
    auxinfo.time = dtime + p -> duration;
    auxinfo.type = qindex;
    auxinfo.next = NULL;
    place(&evlist, &auxinfo);
  }
}
//****************
void place(node  **evlist, node *auxinfo)
{
   node *h, *p, *help;
   help = (node *)malloc(sizeof(struct node));
   *help = *auxinfo;
   if(*evlist == NULL)
      *evlist = help;
   else
   {
       p = h = *evlist;
       while(h != NULL)
       {
	     if(help -> time > h ->time )
	     {
		p = h;
		h = h -> next;
	     }
	     else
		break;
       }//end of while
       help -> next = h;
       if(h == *evlist)
	  *evlist = help;
       else
	  p -> next = help;
   }//end of else
}
//****************
void popsub(node **evlist, node *auxinfo)
{
    auxinfo -> time = (*evlist) -> time;
    auxinfo -> type = (*evlist) -> type;
    auxinfo -> duration = (*evlist) -> duration;
    *evlist = (*evlist) -> next;
}
//*************
void qremove(queue *q1, node *auxinfo)
{
    node *p;
    if(q1 -> front != NULL)
    {
       p = q1 -> front;
       (q1 -> num) --;
       auxinfo ->time = q1 -> front ->time;
       auxinfo ->type = q1 -> front ->type;
       auxinfo ->duration = q1 -> front ->duration;

       q1 -> front = q1 -> front -> next;
       p -> next = NULL;
       free(p);
    }
}
//*************
void insert(queue *q1, node *auxinfo)
{
  node *help;
  help = (node *)malloc(sizeof(struct node));
  *help = *auxinfo;
  (q1 -> num) ++;
  if(q1 -> front == NULL)
      q1->front = q1->rear = help;

  else
     {
       q1 -> rear -> next = help;
       q1 -> rear = q1 -> rear -> next /*auxinfo*/;
     }
}









